/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.service.VWDBExecuteInfo;
import filenet.vw.toolkit.admin.property.service.VWDBExecuteTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.images.VWToolbarButtonFocusAdapter;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWDBExecutePropertyPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
FocusListener {
    private VWDBExecuteInfo m_dbExInfo = null;
    private boolean m_bIsModified = false;
    private JLabel m_dbExecuteNameLabel = null;
    private JButton m_helpButton = null;
    private JLabel m_dbTypeLabel = null;
    private JComboBox m_dbTypeComboBox = null;
    private JRadioButton m_dbParameterBttn = null;
    private JLabel m_dbNameLabel = null;
    private JTextField m_dbNameTextField = null;
    private JLabel m_dbHostLabel = null;
    private JTextField m_dbHostTextField = null;
    private JLabel m_dbPortLabel = null;
    private VWNumericTextField m_dbPortTextField = null;
    private JRadioButton m_jdbcDriverURLBttn = null;
    private JTextArea m_jdbcURLTextArea = null;
    private ButtonGroup m_bg = null;
    private JLabel m_dbUserLabel = null;
    private JTextField m_dbUserTextField = null;
    private JLabel m_dbPasswordLabel = null;
    private JPasswordField m_dbPasswordField = null;
    private VWTable m_dbexecuteTable = null;
    private VWDBExecuteTableModel m_tableModel = null;
    private Dialog m_parentDialog = null;

    public VWDBExecutePropertyPanel(Dialog parentDialog, VWTable dbexecuteTable, VWDBExecuteTableModel tableModel) {
        this.m_parentDialog = parentDialog;
        this.m_dbexecuteTable = dbexecuteTable;
        this.m_tableModel = tableModel;
        this.createControls();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnable) {
        this.m_dbTypeComboBox.setEnabled(bEnable);
        this.m_dbParameterBttn.setEnabled(bEnable);
        this.m_dbNameTextField.setEnabled(bEnable);
        this.m_dbHostTextField.setEnabled(bEnable);
        this.m_dbPortTextField.setEnabled(bEnable);
        this.m_jdbcDriverURLBttn.setEnabled(bEnable);
        this.m_jdbcURLTextArea.setEnabled(bEnable);
        this.m_dbUserTextField.setEnabled(bEnable);
        this.m_dbPasswordField.setEnabled(bEnable);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource().equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc079.htm");
            } else if (event.getSource().equals(this.m_dbTypeComboBox)) {
                this.dbTypeChanged();
            } else if (event.getSource().equals(this.m_dbParameterBttn)) {
                this.jdbcURLSelectionChanged();
            } else if (event.getSource().equals(this.m_jdbcDriverURLBttn)) {
                this.jdbcURLSelectionChanged();
            }
            this.m_dbexecuteTable.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        System.out.println("ListSelectionListener valueChanged");
    }

    protected void enableDBParameters(boolean b) {
        this.m_dbNameTextField.setEditable(b);
        this.m_dbNameTextField.setOpaque(b);
        this.m_dbHostTextField.setEditable(b);
        this.m_dbHostTextField.setOpaque(b);
        this.m_dbPortTextField.setEditable(b);
        this.m_dbPortTextField.setOpaque(b);
        if (b) {
            this.m_dbParameterBttn.setSelected(true);
            this.m_jdbcURLTextArea.setEditable(false);
            this.m_jdbcURLTextArea.setOpaque(false);
        } else {
            this.m_jdbcDriverURLBttn.setSelected(true);
            this.m_jdbcURLTextArea.setEditable(true);
            this.m_jdbcURLTextArea.setOpaque(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDBExecute(VWDBExecuteInfo dbExInfo) {
        try {
            block16: {
                try {
                    this.m_dbExInfo = dbExInfo;
                    this.m_dbTypeComboBox.removeActionListener(this);
                    if (this.m_dbExInfo != null) {
                        this.m_dbExecuteNameLabel.setText(dbExInfo.getName());
                        VWAccessibilityHelper.setAccessibility(this.m_dbExecuteNameLabel, this, this.m_dbExecuteNameLabel.getText(), this.m_dbExecuteNameLabel.getText());
                        this.m_dbTypeComboBox.setSelectedItem(this.m_dbExInfo.getDataBaseType());
                        String dbName = this.m_dbExInfo.getDBName();
                        this.m_dbNameTextField.setText(dbName != null ? dbName : "");
                        String dbHost = this.m_dbExInfo.getDBHost();
                        this.m_dbHostTextField.setText(dbHost != null ? dbHost : "");
                        String dbPort = this.m_dbExInfo.getDBPort();
                        this.m_dbPortTextField.setText(dbPort != null ? dbPort : "");
                        if (this.m_dbExInfo.getURL() != null) {
                            this.m_jdbcURLTextArea.setText(this.m_dbExInfo.getURL());
                        } else {
                            this.buildJDBCURL(false);
                        }
                        if (this.m_dbExInfo.isNew()) {
                            if (this.m_dbExInfo.m_selOption == 0) {
                                this.enableDBParameters(true);
                            } else {
                                this.enableDBParameters(false);
                            }
                        } else if (this.m_dbExInfo.m_nStatus == 0 || this.m_dbExInfo.isModified()) {
                            if (dbName != null && dbName.length() > 0 && dbHost != null && dbHost.length() > 0 && dbPort != null && dbPort.length() > 0) {
                                this.enableDBParameters(true);
                            } else {
                                this.enableDBParameters(false);
                            }
                        }
                        this.m_dbUserTextField.setText(this.m_dbExInfo.getDBUser() != null ? this.m_dbExInfo.getDBUser() : "");
                        String pwd = this.m_dbExInfo.getDBPWD();
                        if (pwd == null || pwd.length() <= 0) {
                            this.m_dbPasswordField.setText("");
                        } else {
                            this.m_dbPasswordField.setText(pwd);
                        }
                        this.setEnabled(true);
                        break block16;
                    }
                    this.m_dbExecuteNameLabel.setText(VWResource.NoDBExecuteSelected);
                    VWAccessibilityHelper.setAccessibility(this.m_dbExecuteNameLabel, this, this.m_dbExecuteNameLabel.getText(), this.m_dbExecuteNameLabel.getText());
                    this.m_dbNameTextField.setText("");
                    this.m_dbHostTextField.setText("");
                    this.m_dbPortTextField.setText("");
                    this.m_jdbcURLTextArea.setText("");
                    this.m_dbUserTextField.setText("");
                    this.m_dbPasswordField.setText("");
                    this.m_jdbcURLTextArea.setText("");
                    this.setEnabled(false);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var7_8 = null;
                    this.m_dbTypeComboBox.addActionListener(this);
                    this.m_bIsModified = false;
                }
            }
            Object var7_7 = null;
            this.m_dbTypeComboBox.addActionListener(this);
            this.m_bIsModified = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_dbTypeComboBox.addActionListener(this);
            this.m_bIsModified = false;
            throw throwable;
        }
    }

    public boolean isModified() {
        if (this.m_tableModel != null && this.m_tableModel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        if (this.m_tableModel != null) {
            this.m_tableModel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    protected void stopEditing() {
        if (this.m_dbexecuteTable != null) {
            this.m_dbexecuteTable.stopEditing();
        }
    }

    protected void releaseResources() {
        this.m_dbExecuteNameLabel = null;
        if (this.m_helpButton != null) {
            this.m_helpButton = null;
        }
        if (this.m_jdbcURLTextArea != null) {
            this.m_jdbcURLTextArea.removeAll();
            this.m_jdbcURLTextArea = null;
        }
        if (this.m_dbHostTextField != null) {
            this.m_dbHostTextField.removeFocusListener(this);
            this.m_dbHostTextField.removeAll();
            this.m_dbHostTextField = null;
        }
        if (this.m_dbNameTextField != null) {
            this.m_dbNameTextField.removeFocusListener(this);
            this.m_dbNameTextField.removeAll();
            this.m_dbNameTextField = null;
        }
        if (this.m_dbPortTextField != null) {
            this.m_dbPortTextField.removeFocusListener(this);
            this.m_dbPortTextField.removeAll();
            this.m_dbPortTextField = null;
        }
        if (this.m_dbUserTextField != null) {
            this.m_dbUserTextField.removeFocusListener(this);
            this.m_dbUserTextField.removeAll();
            this.m_dbUserTextField = null;
        }
        if (this.m_dbPasswordField != null) {
            this.m_dbPasswordField.removeFocusListener(this);
            this.m_dbPasswordField.removeAll();
            this.m_dbPasswordField = null;
        }
        if (this.m_dbParameterBttn != null) {
            this.m_dbParameterBttn = null;
        }
        if (this.m_jdbcDriverURLBttn != null) {
            this.m_jdbcDriverURLBttn = null;
        }
        if (this.m_dbexecuteTable != null) {
            this.m_dbexecuteTable.removeAll();
            this.m_dbexecuteTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.m_dbExInfo = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 4, 2, 4);
            gbCons.gridheight = 1;
            gbCons.gridwidth = -1;
            this.m_dbExecuteNameLabel = new JLabel(VWResource.NoDBExecuteSelected);
            VWAccessibilityHelper.setAccessibility(this.m_dbExecuteNameLabel, this, VWResource.Name, VWResource.Name);
            this.add((Component)this.m_dbExecuteNameLabel, gbCons);
            gbCons.anchor = 22;
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            this.m_helpButton = (JButton)VWImageLoader.createToolBarButton("help20.gif", VWResource.Help, false);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.getAccessibleContext().setAccessibleName(VWResource.Help);
            this.m_helpButton.addFocusListener(new VWToolbarButtonFocusAdapter(this.m_helpButton));
            this.m_helpButton.setRolloverEnabled(true);
            this.m_helpButton.setFocusable(true);
            this.m_helpButton.setBorderPainted(false);
            this.add((Component)this.m_helpButton, gbCons);
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.1;
            this.add((Component)this.getDBTypePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            this.add((Component)this.getJDBCURLPanel(), gbCons);
            ++gbCons.gridy;
            this.add((Component)this.getDBCredentialPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDBTypePanel() {
        try {
            JPanel dbTypePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 4, 2, 4);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            this.m_dbTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabaseType));
            VWAccessibilityHelper.setAccessibility(this.m_dbTypeLabel, this, VWResource.DatabaseType, VWResource.DatabaseType);
            dbTypePanel.add((Component)this.m_dbTypeLabel, gbCons);
            gbCons.weightx = 1.0;
            gbCons.gridx = 1;
            gbCons.gridwidth = 0;
            this.m_dbTypeComboBox = new JComboBox<Object>(new Object[]{VWResource.MSSQL, VWResource.Oracle, VWResource.DB2});
            this.m_dbTypeComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_dbTypeComboBox.addActionListener(this);
            this.m_dbTypeComboBox.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbTypeComboBox, this, VWResource.DatabaseType, VWResource.DatabaseType);
            VWAccessibilityHelper.setLabelFor(this.m_dbTypeLabel, this.m_dbTypeComboBox);
            dbTypePanel.add((Component)this.m_dbTypeComboBox, gbCons);
            return dbTypePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getDBParametersPanel() {
        try {
            JPanel dbParametersPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 4, 2, 4);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            this.m_dbNameLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabaseName));
            VWAccessibilityHelper.setAccessibility(this.m_dbNameLabel, this, VWResource.DatabaseName, VWResource.DatabaseName);
            dbParametersPanel.add((Component)this.m_dbNameLabel, gbCons);
            gbCons.weightx = 1.0;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_dbNameTextField = new JTextField();
            this.m_dbNameTextField.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbNameTextField, this, VWResource.DatabaseName, VWResource.DatabaseName);
            VWAccessibilityHelper.setLabelFor(this.m_dbNameLabel, this.m_dbNameTextField);
            dbParametersPanel.add((Component)this.m_dbNameTextField, gbCons);
            gbCons.weightx = 0.1;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            this.m_dbHostLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabaseHost));
            VWAccessibilityHelper.setAccessibility(this.m_dbHostLabel, this, VWResource.DatabaseHost, VWResource.DatabaseHost);
            dbParametersPanel.add((Component)this.m_dbHostLabel, gbCons);
            gbCons.weightx = 1.0;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_dbHostTextField = new JTextField();
            this.m_dbHostTextField.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbHostTextField, this, VWResource.DatabaseHost, VWResource.DatabaseHost);
            VWAccessibilityHelper.setLabelFor(this.m_dbHostLabel, this.m_dbHostTextField);
            dbParametersPanel.add((Component)this.m_dbHostTextField, gbCons);
            gbCons.weightx = 0.1;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            this.m_dbPortLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabasePort));
            VWAccessibilityHelper.setAccessibility(this.m_dbPortLabel, this, VWResource.DatabasePort, VWResource.DatabasePort);
            dbParametersPanel.add((Component)this.m_dbPortLabel, gbCons);
            gbCons.weightx = 1.0;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_dbPortTextField = new VWNumericTextField(10, 0, false);
            this.m_dbPortTextField.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbPortTextField, this, VWResource.DatabasePort, VWResource.DatabasePort);
            VWAccessibilityHelper.setLabelFor(this.m_dbPortLabel, this.m_dbPortTextField);
            dbParametersPanel.add((Component)this.m_dbPortTextField, gbCons);
            return dbParametersPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getJDBCURLPanel() {
        try {
            JPanel jdbcURLPanel = new JPanel(new GridBagLayout());
            jdbcURLPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.JDBC));
            this.m_bg = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 4, 2, 4);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            this.m_dbParameterBttn = new JRadioButton(VWResource.DatabaseParameters, true);
            this.m_bg.add(this.m_dbParameterBttn);
            this.m_dbParameterBttn.addActionListener(this);
            jdbcURLPanel.add((Component)this.m_dbParameterBttn, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 20, 0, 0);
            jdbcURLPanel.add((Component)this.getDBParametersPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(2, 4, 2, 4);
            this.m_jdbcDriverURLBttn = new JRadioButton(VWResource.JDBCDriverURL);
            this.m_bg.add(this.m_jdbcDriverURLBttn);
            this.m_jdbcDriverURLBttn.addActionListener(this);
            jdbcURLPanel.add((Component)this.m_jdbcDriverURLBttn, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_dbParameterBttn, jdbcURLPanel, VWResource.DatabaseParameters, VWResource.DatabaseParameters);
            VWAccessibilityHelper.setAccessibility(this.m_jdbcDriverURLBttn, jdbcURLPanel, VWResource.JDBCDriverURL, VWResource.JDBCDriverURL);
            VWAccessibilityHelper.setMemberOf(this.m_dbParameterBttn, this.m_bg);
            VWAccessibilityHelper.setMemberOf(this.m_jdbcDriverURLBttn, this.m_bg);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 20, 4, 0);
            this.m_jdbcURLTextArea = new JTextArea();
            this.m_jdbcURLTextArea.setLineWrap(true);
            this.m_jdbcURLTextArea.setWrapStyleWord(true);
            this.m_jdbcURLTextArea.setRows(3);
            this.m_jdbcURLTextArea.setEditable(false);
            this.m_jdbcURLTextArea.setOpaque(false);
            this.m_jdbcURLTextArea.addFocusListener(this);
            this.buildJDBCURL(false);
            VWAccessibilityHelper.setAccessibility(this.m_jdbcURLTextArea, this, VWResource.JDBCDriverURL, VWResource.JDBCDriverURL);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.JDBCDriverURL), this.m_jdbcURLTextArea);
            jdbcURLPanel.add((Component)new JScrollPane(this.m_jdbcURLTextArea), gbCons);
            return jdbcURLPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getDBCredentialPanel() {
        try {
            JPanel dbCredentialPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 4, 2, 4);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            this.m_dbUserLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabaseUser));
            VWAccessibilityHelper.setAccessibility(this.m_dbUserLabel, this, VWResource.DatabaseUser, VWResource.DatabaseUser);
            dbCredentialPanel.add((Component)this.m_dbUserLabel, gbCons);
            gbCons.weightx = 1.0;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_dbUserTextField = new JTextField();
            this.m_dbUserTextField.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbUserTextField, this, VWResource.DatabaseUser, VWResource.DatabaseUser);
            VWAccessibilityHelper.setLabelFor(this.m_dbUserLabel, this.m_dbUserTextField);
            dbCredentialPanel.add((Component)this.m_dbUserTextField, gbCons);
            gbCons.weightx = 0.1;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            this.m_dbPasswordLabel = new JLabel(VWResource.s_label.toString(VWResource.DatabasePassword));
            VWAccessibilityHelper.setAccessibility(this.m_dbPasswordLabel, this, VWResource.DatabasePassword, VWResource.DatabasePassword);
            dbCredentialPanel.add((Component)this.m_dbPasswordLabel, gbCons);
            gbCons.weightx = 1.0;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_dbPasswordField = new JPasswordField();
            this.m_dbPasswordField.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_dbPasswordField, this, VWResource.DatabasePassword, VWResource.DatabasePassword);
            VWAccessibilityHelper.setLabelFor(this.m_dbPasswordLabel, this.m_dbPasswordField);
            dbCredentialPanel.add((Component)this.m_dbPasswordField, gbCons);
            return dbCredentialPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleUpdateEvent(FocusEvent event) {
        block30: {
            if (event == null || this.m_dbExInfo == null) {
                return;
            }
            if (event.getSource().equals(this.m_dbNameTextField)) {
                try {
                    if (VWStringUtils.compare(this.m_dbExInfo.getDBName(), this.m_dbNameTextField.getText()) == 0) break block30;
                    this.m_dbExInfo.setDBName(this.m_dbNameTextField.getText());
                    this.buildJDBCURL(true);
                    this.m_bIsModified = true;
                    if (!this.m_dbExInfo.isNew()) {
                        this.m_dbPasswordField.setText("");
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbNameTextField.selectAll();
                }
            } else if (event.getSource().equals(this.m_dbHostTextField)) {
                try {
                    if (VWStringUtils.compare(this.m_dbExInfo.getDBHost(), this.m_dbHostTextField.getText()) == 0) break block30;
                    this.m_dbExInfo.setDBHost(this.m_dbHostTextField.getText());
                    this.buildJDBCURL(true);
                    this.m_bIsModified = true;
                    if (!this.m_dbExInfo.isNew()) {
                        this.m_dbPasswordField.setText("");
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbHostTextField.selectAll();
                }
            } else if (event.getSource().equals(this.m_dbPortTextField)) {
                try {
                    if (VWStringUtils.compare(this.m_dbExInfo.getDBPort(), this.m_dbPortTextField.getText()) == 0) break block30;
                    this.m_dbExInfo.setDBPort(this.m_dbPortTextField.getText());
                    this.buildJDBCURL(true);
                    this.m_bIsModified = true;
                    if (!this.m_dbExInfo.isNew()) {
                        this.m_dbPasswordField.setText("");
                    }
                }
                catch (NumberFormatException ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.InvalidPortNumber.toString(this.m_dbPortTextField.getText()), VWResource.ErrorMessage, 0);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbPortTextField.selectAll();
                }
            } else if (event.getSource().equals(this.m_dbUserTextField)) {
                try {
                    if (VWStringUtils.compare(this.m_dbExInfo.getDBUser(), this.m_dbUserTextField.getText()) == 0) break block30;
                    this.m_dbExInfo.setDBUser(this.m_dbUserTextField.getText());
                    this.m_bIsModified = true;
                    if (!this.m_dbExInfo.isNew()) {
                        this.m_dbPasswordField.setText("");
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbUserTextField.selectAll();
                }
            } else if (event.getSource().equals(this.m_dbPasswordField)) {
                try {
                    this.m_dbExInfo.setDBPWD(this.m_dbPasswordField.getText());
                    this.m_bIsModified = true;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbPasswordField.selectAll();
                }
            } else if (event.getSource().equals(this.m_jdbcURLTextArea)) {
                try {
                    this.m_dbExInfo.setURL(this.m_jdbcURLTextArea.getText());
                    this.m_bIsModified = true;
                    if (!this.m_dbExInfo.isNew()) {
                        this.m_dbPasswordField.setText("");
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                    this.m_dbPasswordField.selectAll();
                }
            }
        }
        this.m_dbexecuteTable.updateUI();
    }

    private void dbTypeChanged() {
        String TheDBType = (String)this.m_dbTypeComboBox.getSelectedItem();
        if (TheDBType.compareTo(VWResource.MSSQL) == 0) {
            this.m_dbExInfo.setDBType(1);
        } else if (TheDBType.compareTo(VWResource.Oracle) == 0) {
            this.m_dbExInfo.setDBType(2);
        } else if (TheDBType.compareTo(VWResource.DB2) == 0) {
            this.m_dbExInfo.setDBType(3);
        }
        this.buildJDBCURL(true);
        if (!this.m_dbExInfo.isNew()) {
            this.m_dbPasswordField.setText("");
        }
    }

    private void dbParameterChanged() {
        this.buildJDBCURL(true);
    }

    private void jdbcURLSelectionChanged() {
        if (this.m_jdbcDriverURLBttn.isSelected()) {
            this.m_dbNameTextField.setText("");
            this.m_dbHostTextField.setText("");
            this.m_dbPortTextField.setText("");
            this.enableDBParameters(false);
            if (this.m_dbExInfo != null) {
                this.m_dbExInfo.setURL(this.m_jdbcURLTextArea.getText());
                this.m_dbExInfo.m_selOption = 1;
            }
        } else {
            this.enableDBParameters(true);
            String dbName = this.m_dbExInfo.getDBName();
            this.m_dbNameTextField.setText(dbName != null ? dbName : "");
            String dbHost = this.m_dbExInfo.getDBHost();
            this.m_dbHostTextField.setText(dbHost != null ? dbHost : "");
            String dbPort = this.m_dbExInfo.getDBPort();
            this.m_dbPortTextField.setText(dbPort != null ? dbPort : "");
            this.buildJDBCURL(true);
            this.m_dbExInfo.m_selOption = 0;
        }
        if (!this.m_dbExInfo.isNew()) {
            this.m_dbPasswordField.setText("");
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private String buildJDBCURL(boolean bUpdateDef) {
        String sDbType;
        String dbName;
        String port;
        String url = null;
        String host = this.m_dbHostTextField.getText().trim();
        if (host.equals("")) {
            host = VWResource.TemplateHost;
        }
        if ((port = this.m_dbPortTextField.getText().trim()).equals("")) {
            port = VWResource.TemplatePort;
        }
        if ((dbName = this.m_dbNameTextField.getText().trim()).equals("")) {
            dbName = VWResource.TemplateDatabase;
        }
        if ((sDbType = (String)this.m_dbTypeComboBox.getSelectedItem()).compareTo(VWResource.MSSQL) == 0) {
            url = "jdbc:sqlserver://" + host + ":" + port + ";DatabaseName=" + dbName;
        } else if (sDbType.compareTo(VWResource.Oracle) == 0) {
            url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + dbName;
        } else if (sDbType.compareTo(VWResource.DB2) == 0) {
            url = "jdbc:db2://" + host + ":" + port + "/" + dbName;
        }
        this.m_jdbcURLTextArea.setText(url);
        if (bUpdateDef && this.m_dbExInfo != null) {
            this.m_dbExInfo.setURL(url);
        }
        return url;
    }

    public void focusGained(FocusEvent e) {
        this.m_dbexecuteTable.stopEditing();
    }

    public void focusLost(FocusEvent e) {
        this.handleUpdateEvent(e);
    }
}

